package ru.yandex.autotests.directapi.model.api5.vcards;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.vcards.MapPoint;

public class MapPointMap {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String X_1 = "x1";
    public static final String Y_1 = "y1";
    public static final String X_2 = "x2";
    public static final String Y_2 = "y2";

    private MapPoint item;

    public MapPointMap() {
        item = new MapPoint();
    }

    public MapPoint getBean() {
        return item;
    }

    public MapPointMap defaultPointOnMap() {
        item = new MapPoint()
                .withX(BigDecimal.valueOf(45.733604F))
                .withY(BigDecimal.valueOf(45.72431F))
                .withX1(BigDecimal.valueOf(27.603739F))
                .withY1(BigDecimal.valueOf(27.587273F))
                .withX2(BigDecimal.valueOf(27.570807F))
                .withY2(BigDecimal.valueOf(45.742893F));
        return this;
    }

    public MapPointMap pointOnMapCentered() {
        item = new MapPoint()
                .withX(BigDecimal.valueOf(59.984074F))
                .withY(BigDecimal.valueOf(30.192606F))
                .withX1(BigDecimal.valueOf(59.984177F))
                .withY1(BigDecimal.valueOf(30.192406F))
                .withX2(BigDecimal.valueOf(59.983974F))
                .withY2(BigDecimal.valueOf(30.192507F));
        return this;
    }

    public MapPointMap point(float x, float y, float x1, float y1, float x2, float y2) {
        item.withX(BigDecimal.valueOf(x))
                .withY(BigDecimal.valueOf(y))
                .withX1(BigDecimal.valueOf(x1))
                .withY1(BigDecimal.valueOf(y1))
                .withX2(BigDecimal.valueOf(x2))
                .withY2(BigDecimal.valueOf(y2));
        return this;
    }

    public MapPointMap withX(float value) {
        item.withX(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withY(float value) {
        item.withY(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withX1(float value) {
        item.withX1(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withY1(float value) {
        item.withY1(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withX2(float value) {
        item.withX2(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withY2(float value) {
        item.withY2(new BigDecimal((double) value));
        return this;
    }

    public MapPointMap withX(String value) {
        item.withX(new BigDecimal(value));
        return this;
    }

    public MapPointMap withY(String value) {
        item.withY(new BigDecimal(value));
        return this;
    }

    public MapPointMap withX1(String value) {
        item.withX1(new BigDecimal(value));
        return this;
    }

    public MapPointMap withY1(String value) {
        item.withY1(new BigDecimal(value));
        return this;
    }

    public MapPointMap withX2(String value) {
        item.withX2(new BigDecimal(value));
        return this;
    }

    public MapPointMap withY2(String value) {
        item.withY2(new BigDecimal(value));
        return this;
    }
}
