package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.Phone;

public class PhoneMap {
    public static final String COUNTRY_CODE = "countryCode";
    public static final String CITY_CODE = "cityCode";
    public static final String PHONE_NUMBER = "phoneNumber";
    public static final String EXTENSION = "extension";

    private Phone item;

    public PhoneMap() {
        item = new Phone();
    }

    public Phone getBean() {
        return item;
    }

    public PhoneMap defaultPhone() {
        item = new Phone()
                .withCountryCode("+7")
                .withCityCode("812")
                .withPhoneNumber("123-45-67")
                .withExtension("89");
        return this;
    }

    public PhoneMap withCountryCode(String value) {
        item.withCountryCode(value);
        return this;
    }

    public PhoneMap withCityCode(String value) {
        item.withCityCode(value);
        return this;
    }

    public PhoneMap withPhoneNumber(String value) {
        item.withPhoneNumber(value);
        return this;
    }

    public PhoneMap withExtension(String value) {
        item.withExtension(value);
        return this;
    }
}
