package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.VCardAddItem;
import org.apache.commons.lang.RandomStringUtils;

public class VCardAddMap {
    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String COUNTRY = "country";
    public static final String CITY = "city";
    public static final String WORK_TIME = "workTime";
    public static final String PHONE = "phone";
    public static final String STREET = "street";
    public static final String HOUSE = "house";
    public static final String BUILDING = "building";
    public static final String APARTMENT = "apartment";
    public static final String INSTANT_MESSENGER = "instantMessenger";
    public static final String COMPANY_NAME = "companyName";
    public static final String EXTRA_MESSAGE = "extraMessage";
    public static final String CONTACT_EMAIL = "contactEmail";
    public static final String OGRN = "ogrn";
    public static final String METRO_STATION_ID = "metroStationId";
    public static final String POINT_ON_MAP = "pointOnMap";
    public static final String CONTACT_PERSON = "contactPerson";

    private VCardAddItem item;

    public VCardAddMap() {
        item = new VCardAddItem();
    }

    public VCardAddItem getBean() {
        return item;
    }

    public VCardAddMap defaultContacts() {
        String extraMsg =
                "Подробности о товаре. Весь текст составляет в 'длину ровно \"\"200 \\ символов. &qoute &mdash & &lquote &rqoute +";
        extraMsg = extraMsg + RandomStringUtils.randomAlphabetic(200 - extraMsg.length());
        item = new VCardAddItem()
                .withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone().getBean())
                .withStreet("вуліца Камуністычная").withHouse("28")
                .withApartment("24")
                .withBuilding("3")
                .withInstantMessenger(new InstantMessengerMap().defaultInstantMessenger().getBean())
                .withCompanyName("Питер-сити")
                .withExtraMessage(extraMsg)
                .withContactEmail("at-tester@yandex-team.ru")
                .withOgrn("309547504300018")
                .withContactPerson("Порфирий Покрышкин из API");
        return this;
    }

    public VCardAddMap shortContacts() {
        item = new VCardAddItem()
                .withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withCompanyName("Питер-сити")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone().getBean());
        return this;
    }

    public VCardAddMap withCampaignId(long campaingId) {
        item.withCampaignId(campaingId);
        return this;
    }

    public VCardAddMap withCountry(String country) {
        item.withCountry(country);
        return this;
    }

    public VCardAddMap withCity(String city) {
        item.withCity(city);
        return this;
    }

    public VCardAddMap withWorkTime(String workTime) {
        item.withWorkTime(workTime);
        return this;
    }

    public VCardAddMap withPhone(PhoneMap phone) {
        item.withPhone(phone == null ? null : phone.getBean());
        return this;
    }

    public VCardAddMap withStreet(String street) {
        item.withStreet(street);
        return this;
    }

    public VCardAddMap withHouse(String house) {
        item.withHouse(house);
        return this;
    }

    public VCardAddMap withBuilding(String building) {
        item.withBuilding(building);
        return this;
    }

    public VCardAddMap withApartment(String apartment) {
        item.withApartment(apartment);
        return this;
    }

    public VCardAddMap withInstantMessenger(InstantMessengerMap im) {
        item.withInstantMessenger(im == null ? null : im.getBean());
        return this;
    }

    public VCardAddMap withCompanyName(String companyName) {
        item.withCompanyName(companyName);
        return this;
    }

    public VCardAddMap withExtraMessage(String extraMessage) {
        item.withExtraMessage(extraMessage);
        return this;
    }

    public VCardAddMap withContactEmail(String email) {
        item.withContactEmail(email);
        return this;
    }

    public VCardAddMap withContactPerson(String contactPerson) {
        item.withContactPerson(contactPerson);
        return this;
    }

    public VCardAddMap withPointOnMap(MapPointMap point) {
        item.withPointOnMap(point == null ? null : point.getBean());
        return this;
    }

    public VCardAddMap withMetroStation(Long stationId) {
        item.withMetroStationId(stationId);
        return this;
    }

    public VCardAddMap withOgrn(String ogrn) {
        item.withOgrn(ogrn);
        return this;
    }
}
