package ru.yandex.autotests.directapi.model.campaigns;


import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.testing.data.TestFullGoals;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Цель должна быть активная в активном счетчике не составная:
 * PPCDICT SELECT * FROM metrika_goals mg WHERE mg.goal_id=774871
 */
public class MetrikaGoals {
    public static final int VALID_COUNTER_ID = 1;
    public static final long VALID_GOAL_ID = 55L;
    public static final Goal VALID_GOAL =
            (Goal) TestFullGoals.defaultGoal(VALID_GOAL_ID).withCounterId(VALID_COUNTER_ID);
    public static final int INACCESSIBLE_COUNTER_ID = 34981090;
    public static final long INACCESSIBLE_GOAL_ID = 17108070L;

    /**
     * @deprecated метод можно не использовать, он всегда возвращает одно и то же значение
     * {@link MetrikaGoals#VALID_COUNTER_ID}
     */
    @Deprecated
    public static Integer getCounterForLogin(String login) {
        return VALID_COUNTER_ID;
    }

    public static Long[] getConterGoalIds(Integer counterId, int numOfGoals) {
        switch (numOfGoals) {
            case 0:
                return new Long[0];
            case 1:
                return new Long[]{VALID_GOAL_ID};
            default:
                throw new DirectAPIException("Недостаточное количество целей у счетчика");
        }
    }

    /**
     * @deprecated метод можно не использовать, он всегда возвращает одно и то же значение
     * * {@link MetrikaGoals#VALID_GOAL_ID}
     */
    @Deprecated
    public static Long getGoalForCounter(Integer counterId) {
        if (counterId == VALID_COUNTER_ID) {
            return VALID_GOAL_ID;
        }
        throw new DirectAPIException("Не найдены цели для счетчика " + counterId);
    }
}
