package ru.yandex.autotests.directapi.steps;

import java.util.ArrayList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.direct.api.v5.adgroups.AddRequest;
import com.yandex.direct.api.v5.adgroups.AddResponse;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupAdd;
import com.yandex.direct.api.v5.general.ActionResult;

import ru.yandex.autotests.directapi.apiclient.ApiClient;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceAdGroupInfo;
import ru.yandex.direct.core.testing.steps.Steps;

import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.Action.DELETE;
import static ru.yandex.autotests.directapi.model.api5.Action.GET;
import static ru.yandex.autotests.directapi.model.api5.Action.UPDATE;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.AD_GROUPS;

public class AdGroupsSteps extends BaseApiSteps {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private final Steps steps;

    public AdGroupsSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
        steps = state.getApplicationContext().getBean(Steps.class);
    }

    public Object shouldGetResultOnAdd(AddRequestMap request, ExpectedResult... expectedResults) {
        AddRequest bean = request.getBean();
        String clientLogin = state.getClientLogin();
        ApiClient apiClient = defaultClientV5();
        Object response = apiClient.invokeMethod(AD_GROUPS, clientLogin, ADD, bean);
        ArrayList<ActionResult> actualResult = extractActionResults(response, ADD);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnUpdate(UpdateRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(AD_GROUPS, state.getClientLogin(), UPDATE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, UPDATE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnDelete(DeleteRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(AD_GROUPS, state.getClientLogin(), DELETE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, DELETE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public GetResponse adGroupsGet(GetRequestMap request) {
        return defaultClientV5().invokeMethod(AD_GROUPS, state.getClientLogin(), GET, request.getBean());
    }

    public AddResponse adGroupsAdd(AddRequestMap request) {
        return defaultClientV5().invokeMethod(AD_GROUPS, state.getClientLogin(), ADD, request.getBean());
    }

    public Long addDefaultGroup(Long campaignId) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId));
    }

    public Long addDefaultGroup(Long campaignId, AdGroupType type) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId).withDefaultGroup(type));
    }

    public Long addDefaultMobileGroup(Long campaignId) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroupAddMap(new MobileAppAdGroupAddMap().defaultGroup()));
    }

    public Long addDefaultPerformanceGroup(Long campaignId, Long feedId) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withPerformanceAdGroup(new SmartAdGroupAdd().withFeedId(feedId)));
    }

    public Long addDefaultGroupDynamic(Long campaignId) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withDynamicTextAdGroup((new DynamicTextAdGroupMap()).defaultGroup()));
    }

    public Long addGroup(AdGroupAddItemMap adGroupAddItemMap) {
        return adGroupsAdd(new AddRequestMap().withAdGroups(adGroupAddItemMap))
                .getAddResults().get(0).getId();
    }

    public PerformanceAdGroupInfo addDefaultPerformanceAdGroup() {
        return steps.adGroupSteps().createDefaultPerformanceAdGroup();
    }

    public PerformanceAdGroupInfo addDefaultPerformanceAdGroup(ClientInfo clientInfo) {
        return steps.adGroupSteps().createDefaultPerformanceAdGroup(clientInfo);
    }

}
