package ru.yandex.autotests.directapi.steps;

import java.util.ArrayList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.direct.api.v5.ads.AdBuilderAdAddItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.ArchiveResponse;
import com.yandex.direct.api.v5.ads.DeleteResponse;
import com.yandex.direct.api.v5.ads.SmartAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.SuspendResponse;
import com.yandex.direct.api.v5.ads.UnarchiveResponse;
import com.yandex.direct.api.v5.general.ActionResult;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.ModerateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;

import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.Action.ARCHIVE;
import static ru.yandex.autotests.directapi.model.api5.Action.DELETE;
import static ru.yandex.autotests.directapi.model.api5.Action.MODERATE;
import static ru.yandex.autotests.directapi.model.api5.Action.RESUME;
import static ru.yandex.autotests.directapi.model.api5.Action.SUSPEND;
import static ru.yandex.autotests.directapi.model.api5.Action.UNARCHIVE;
import static ru.yandex.autotests.directapi.model.api5.Action.UPDATE;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.ADS;

public class AdsSteps extends BaseApiSteps {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public AdsSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    public Object shouldGetResultOnAdd(AddRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), ADD, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, ADD);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnUpdate(UpdateRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), UPDATE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, UPDATE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnDelete(DeleteRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), DELETE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, DELETE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnModerate(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnModerate(new ModerateRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public Object shouldGetResultOnModerate(ModerateRequestMap moderateRequestMap, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), MODERATE,
                moderateRequestMap.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, MODERATE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnArchive(ArchiveRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), ARCHIVE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, ARCHIVE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnUnarchive(UnarchiveRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), UNARCHIVE, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, UNARCHIVE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnSuspend(SuspendRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), SUSPEND, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, SUSPEND);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnResume(ResumeRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ADS, state.getClientLogin(), RESUME, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, RESUME);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public AddResponse adsAdd(AddRequestMap request, String login) {
        return defaultClientV5().invokeMethod(ADS, login, ADD, request.getBean());
    }

    public DeleteResponse adsDelete(DeleteRequestMap request, String login) {
        return defaultClientV5().invokeMethod(ADS, login, DELETE, request.getBean());
    }

    public ArchiveResponse adsArchive(ArchiveRequestMap request, String login) {
        return defaultClientV5().invokeMethod(ADS, login, ARCHIVE, request.getBean());
    }

    public UnarchiveResponse adsUnarchive(UnarchiveRequestMap request, String login) {
        return defaultClientV5().invokeMethod(ADS, login, UNARCHIVE, request.getBean());
    }

    public SuspendResponse adsSuspend(SuspendRequestMap request, String login) {
        return defaultClientV5().invokeMethod(ADS, login, SUSPEND, request.getBean());
    }

    // AdsAdd
    public AddResponse adsAdd(AddRequestMap request) {
        return adsAdd(request, state.getClientLogin());
    }

    public Long addAd(AdAddItemMap adAddItemMap) {
        return addAd(adAddItemMap, state.getClientLogin());
    }

    public Long addAd(AdAddItemMap adAddItemMap, String login) {
        return adsAdd(new AddRequestMap().withAds(adAddItemMap), login)
                .getAddResults().get(0).getId();
    }

    // AddDefaultAdd
    public Long addDefaultAd(Long adGroupId, OldBannerType type) {
        return addAd(new AdAddItemMap().withDefaultAd(type).withAdGroupId(adGroupId));
    }

    // AddDefaultTextAd
    public Long addDefaultTextAd(Long adGroupId) {
        return addDefaultTextAd(adGroupId, state.getClientLogin());
    }

    public Long addDefaultTextAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap().withTextAd(new TextAdAddMap().defaultTextAd()).withAdGroupId(adGroupId), login);
    }

    // AddDefaultTextImageAd
    public Long addDefaultTextImageAd(Long adGroupId, String adImageHash) {
        return addDefaultTextImageAd(adGroupId, adImageHash, state.getClientLogin());
    }

    public Long addDefaultTextImageAd(Long adGroupId, String adImageHash, String login) {
        return addAd(new AdAddItemMap().withTextImageAd(new TextImageAdAddMap().defaultTextImageAd(adImageHash))
                .withAdGroupId(adGroupId), login);
    }

    // AddDefaultMobileAppAd
    public Long addDefaultMobileAppImageAd(Long adGroupId, String adImageHash) {
        return addDefaultMobileAppImageAd(adGroupId, adImageHash, state.getClientLogin());
    }

    public Long addDefaultMobileAppImageAd(Long adGroupId, String adImageHash, String login) {
        return addAd(new AdAddItemMap()
                .withMobileAppImageAd(new MobileAppImageAdAddMap().defaultMobileAppImageAd(adImageHash))
                .withAdGroupId(adGroupId), login);
    }

    // AddDefaultMobileAppAd
    public Long addDefaultMobileAppAd(Long adGroupId) {
        return addDefaultMobileAppAd(adGroupId, state.getClientLogin());
    }

    public Long addDefaultMobileAppAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()), login);
    }

    // AddDefaultDynamicTextAd
    public Long addDefaultDynamicTextAd(Long adGroupId) {
        return addDefaultDynamicTextAd(adGroupId, state.getClientLogin());
    }

    public Long addDefaultDynamicTextAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap().withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                .withAdGroupId(adGroupId), login);
    }

    // AdsDelete
    public DeleteResponse adsDelete(Long... ids) {
        return adsDelete(state.getClientLogin(), (Long[]) ids);
    }

    public DeleteResponse adsDelete(String login, Long... ids) {
        return adsDelete(new DeleteRequestMap().withSelectionCriteria((new IdsCriteriaMap()).withIds(ids)), login);
    }

    public ArchiveResponse adsArchive(Long... ids) {
        IdsCriteriaMap selectionCriteria = (new IdsCriteriaMap()).withIds(ids);
        ArchiveRequestMap request = new ArchiveRequestMap().withSelectionCriteria(selectionCriteria);
        return adsArchive(request, state.getClientLogin());
    }

    public UnarchiveResponse adsUnarchive(Long... ids) {
        IdsCriteriaMap selectionCriteria = (new IdsCriteriaMap()).withIds(ids);
        UnarchiveRequestMap request = new UnarchiveRequestMap().withSelectionCriteria(selectionCriteria);
        return adsUnarchive(request, state.getClientLogin());
    }

    public SuspendResponse adsSuspend(Long... ids) {
        IdsCriteriaMap selectionCriteria = (new IdsCriteriaMap()).withIds(ids);
        SuspendRequestMap request = new SuspendRequestMap().withSelectionCriteria(selectionCriteria);
        return adsSuspend(request, state.getClientLogin());
    }

    public Long addDefaultPerformanceAd(Long adGroupId, Long creativeId) {
        var addItem = new AdBuilderAdAddItem().withCreativeId(creativeId);
        var smartAdBuilderAd = new SmartAdBuilderAdAdd().withCreative(addItem);
        return addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withSmartAdBuilderAd(smartAdBuilderAd));
    }

}
