package ru.yandex.autotests.directapi.steps;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.autotests.directapi.authentication.DummyAuthenticationContainer;
import ru.yandex.autotests.directapi.configuration.AutotestsConfiguration;
import ru.yandex.autotests.directapi.configuration.JettyInstance;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.testing.info.ClientInfo;

public class ApiStepsState {
    private static final Logger logger = LoggerFactory.getLogger(ApiStepsState.class);

    private WebApplicationContext applicationContext;

    private ClientInfo clientInfo = null;
    private User user = null;
    private JettyInstance api;
    private String token = null;

    public ApiStepsState() {
        logger.info("Starting API");
        api = AutotestsConfiguration.getInstance().api();
        logger.info(String.format("API has %d servlets configured",
                api.context.getServletContext().getAttributeEntrySet().size()));
        applicationContext = (WebApplicationContext) api.context.getServletContext()
                .getAttributeEntrySet()
                .stream()
                .peek(e -> logger.info(e.getKey()))
                .filter(e -> e.getKey().contains("spring-ws"))
                .map(Map.Entry::getValue)
                .findFirst()
                .orElseThrow(() -> new RuntimeException("Unable to get application context from servlet"));
    }

    public String getClientLogin() {
        if (user != null) {
            return this.user.getLogin();
        } else if (clientInfo != null) {
            return this.clientInfo.getLogin();
        }
        throw new IllegalStateException("userInfo or clientInfo must be not null");
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        this.token = DummyAuthenticationContainer.getToken(clientInfo.getLogin());
    }

    public void setUser(User user) {
        this.user = user;
        this.token = DummyAuthenticationContainer.getToken(user.getLogin());
    }

    public WebApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public String getToken() {
        return token;
    }

    public JettyInstance getApi() {
        return api;
    }

    public ClientInfo getClientInfo() {
        return clientInfo;
    }

}
