package ru.yandex.autotests.directapi.steps;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.core.testing.info.BannerCreativeInfo;
import ru.yandex.direct.core.testing.info.PerformanceAdGroupInfo;
import ru.yandex.direct.core.testing.steps.Steps;

public class BannerCreativeSteps extends BaseApiSteps {
    private final Steps steps;

    public BannerCreativeSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
        steps = state.getApplicationContext().getBean(Steps.class);
    }

    public BannerCreativeInfo<OldPerformanceBanner> createPerformanceBannerCreative(PerformanceAdGroupInfo adGroupInfo) {
        return steps.bannerCreativeSteps().createPerformanceBannerCreative(adGroupInfo);
    }
}
