package ru.yandex.autotests.directapi.steps;

import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerRepository;
import ru.yandex.direct.dbutil.QueryWithForbiddenShardMapping;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

import static java.util.Collections.singleton;

public class BannersFakeSteps {
    private final ShardHelper shardHelper;
    private final OldBannerRepository bannerRepository;

    public BannersFakeSteps(ApiStepsState state) {
        shardHelper = state.getApplicationContext().getBean(ShardHelper.class);
        bannerRepository = state.getApplicationContext().getBean(OldBannerRepository.class);
    }

    @Nullable
    @QueryWithForbiddenShardMapping("Автотесты")
    public BannerFakeInfo getBannerParams(Long bannerId) {
        int shard = shardHelper.getShardByBannerId(bannerId);
        return StreamEx.of(bannerRepository.getBanners(shard, singleton(bannerId)))
                .findFirst()
                .map(BannerFakeInfo::fromBanner)
                .orElse(null);
    }

    @QueryWithForbiddenShardMapping("Автотесты")
    public void updateStatusModerate(Long bannerId, OldBannerStatusModerate status) {
        int shard = shardHelper.getShardByBannerId(bannerId);
        bannerRepository.updateStatusModerate(shard, List.of(bannerId), status);
    }
}
