package ru.yandex.autotests.directapi.steps;

import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.AddResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.MultiIdsActionResult;
import one.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;

import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.Action.DELETE;
import static ru.yandex.autotests.directapi.model.api5.Action.SET;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.BID_MODIFIERS;

public class BidModifiersSteps extends BaseApiSteps {

    public BidModifiersSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    private <T> Object shouldGetResultOn(String login, Action action, T args, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(ServiceNames.BID_MODIFIERS, login, action, args);
        List<ActionResult> actualResult = extractActionResults(response, action);
        checkActionResults(actualResult, expectedResults);
        return response;
    }


    public Object shouldGetResultOnAdd(BidModifierAddMap request, MultiIdsExpectedResult... expectedResults) {
        AddRequestMap addRequestMap = new AddRequestMap().withBidModifiers(request);
        Object response = defaultClientV5().invokeMethod(ServiceNames.BID_MODIFIERS,
                state.getClientLogin(),
                Action.ADD,
                addRequestMap.getBean()
        );
        List<MultiIdsActionResult> actualResult = extractActionResults(response, Action.ADD);
        checkMultiIdsActionResults(actualResult, expectedResults);
        return response;
    }

    public List<Long> bidModifiersAdd(BidModifierAddMap request) {
        AddRequestMap addRequestMap = new AddRequestMap().withBidModifiers(request);
        AddResponse addResponse =
                defaultClientV5().invokeMethod(BID_MODIFIERS, state.getClientLogin(), ADD, addRequestMap.getBean());
        return StreamEx.of(addResponse.getAddResults())
                .map(MultiIdsActionResult::getIds)
                .flatMap(Collection::stream)
                .toList();
    }

    public Object shouldGetResultOnDelete(List<Long> bmIds, ExpectedResult... expectedResults) {
        DeleteRequestMap request = new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(bmIds));
        return shouldGetResultOn(state.getClientLogin(), DELETE, request.getBean(), expectedResults);
    }

    public Object shouldGetResultOnSet(BidModifierSetMap request, ExpectedResult... expectedResults) {
        SetRequestMap setRequestMap = new SetRequestMap().withBidModifiers(request);
        return shouldGetResultOn(state.getClientLogin(), SET, setRequestMap.getBean(), expectedResults);
    }

}
