package ru.yandex.autotests.directapi.steps;

import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.creatives.CreativeFieldEnum;
import com.yandex.direct.api.v5.creatives.CreativeGetItem;
import com.yandex.direct.api.v5.creatives.GetRequest;
import com.yandex.direct.api.v5.creatives.GetResponse;
import com.yandex.direct.api.v5.creatives.ObjectFactory;
import com.yandex.direct.api.v5.creatives.SmartCreativeFieldEnum;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.CreativeInfo;
import ru.yandex.direct.core.testing.steps.Steps;

import static java.util.Collections.singleton;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.CREATIVES;
import static ru.yandex.direct.core.testing.data.TestCreatives.defaultPerformanceCreative;

public class CreativeSteps extends BaseApiSteps {
    private static final ObjectFactory FACTORY = new ObjectFactory();

    private final CreativeService creativeService;
    private final Steps steps;

    public CreativeSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
        steps = state.getApplicationContext().getBean(Steps.class);
        creativeService = state.getApplicationContext().getBean(CreativeService.class);
    }

    public CreativeInfo addDefaultPerformanceCreative(ClientInfo clientInfo) {
        Creative creative = defaultPerformanceCreative(null, null);
        return addDefaultPerformanceCreative(clientInfo, creative);
    }

    public CreativeInfo addDefaultPerformanceCreative(ClientInfo clientInfo, Creative creative) {
        return steps.creativeSteps().createCreative(creative, clientInfo);
    }

    public List<Creative> getCreatives(ClientInfo clientInfo, List<Long> creativeIds, Collection<CreativeType> types) {
        return creativeService.get(clientInfo.getClientId(), creativeIds, types);
    }

    public CreativeGetItem getCreativeGetItem(Long creativeId) {
        GetRequest getRequest = new GetRequest()
                .withSelectionCriteria(
                        FACTORY.createCreativesSelectionCriteria()
                                .withIds(singleton(creativeId)))
                .withFieldNames(CreativeFieldEnum.values())
                .withSmartCreativeFieldNames(SmartCreativeFieldEnum.values());
        GetResponse getResponse = sendGetRequest(getRequest);
        return getResponse.getCreatives().get(0);
    }

    public GetResponse sendGetRequest(GetRequest getRequest) {
        return defaultClientV5().invokeMethod(CREATIVES, state.getClientLogin(), Action.GET, getRequest);
    }

}
