package ru.yandex.autotests.directapi.steps;

import org.jooq.DSLContext;

import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

public class DirectJooqDbSteps {
    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;
    private DSLContext dslContext = null;

    public DirectJooqDbSteps(ApiStepsState state) {
        var context = state.getApplicationContext();
        dslContextProvider = context.getBean(DslContextProvider.class);
        shardHelper = context.getBean(ShardHelper.class);
    }

    public DirectJooqDbSteps useShardForLogin(String login) {
        int shard = shardHelper.getShardByLoginStrictly(login);
        dslContext = dslContextProvider.ppc(shard);
        return this;
    }

    public DirectJooqDbSteps useShardForClient(ClientInfo client) {
        dslContext = dslContextProvider.ppc(client.getShard());
        return this;
    }

    public DSLContext getContext() {
        return dslContext;
    }
}
