package ru.yandex.autotests.directapi.steps;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@ParametersAreNonnullByDefault
public class DynamicTextAdTargetsSteps extends BaseApiSteps {
    public DynamicTextAdTargetsSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    public AddResponse dynamicTextAdTargetsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD,
                (AddRequest) parameters.getBean());
    }

    public Long addDefaultWebpage(Long pid) {
        return addDefaultWebpage(pid, state.getClientLogin());
    }

    public Long addDefaultWebpage(Long pid, String login) {
        AddResponse response = dynamicTextAdTargetsAdd(new AddRequestMap()
                .withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(new WebpageConditionMap().defaultWebpage())
                                .withBid(30000000L)
                ), login);
        assumeThat("был создан один объект Webpage", response.getAddResults(), hasSize(1));
        return response.getAddResults().get(0).getId();
    }
}
