package ru.yandex.autotests.directapi.steps;

import javax.annotation.Nullable;

import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

public class FeatureSteps {
    private final ApiStepsState state;
    private final ru.yandex.direct.core.testing.steps.FeatureSteps featureSteps;

    public FeatureSteps(ApiStepsState state) {
        this.state = state;
        featureSteps = state.getApplicationContext().getBean(ru.yandex.direct.core.testing.steps.FeatureSteps.class);
    }

    public void ensureClientHasFeature(FeatureName featureName) {
        setClientFeature((ClientId) null, featureName, true);
    }

    public void ensureClientHasFeature(@Nullable ClientId clientId, FeatureName featureName) {
        setClientFeature(clientId, featureName, true);
    }

    public void ensureClientHasFeature(@Nullable ClientInfo client, FeatureName featureName) {
        setClientFeature(client, featureName, true);
    }

    /**
     * @deprecated скорее всего нужно использовать метод {@link FeatureSteps#ensureClientHasFeature}
     */
    @Deprecated
    public void ensureClientHasFeatureIfNotSet(@Nullable ClientId clientId, FeatureName featureName) {
        setClientFeature(clientId, featureName, true);
    }

    public void setClientFeature(@Nullable ClientId clientId, FeatureName featureName, boolean enabled) {
        featureSteps.addClientFeature(clientId, featureName, enabled);
    }

    public void setClientFeature(@Nullable ClientInfo client, FeatureName featureName, boolean enabled) {
        ClientId clientId = client != null ? client.getClientId() : state.getClientInfo().getClientId();
        setClientFeature(clientId, featureName, enabled);
    }
}
