package ru.yandex.autotests.directapi.steps;

import java.util.List;

import com.yandex.direct.api.v5.feeds.AddRequest;
import com.yandex.direct.api.v5.feeds.DeleteRequest;
import com.yandex.direct.api.v5.feeds.GetRequest;
import com.yandex.direct.api.v5.feeds.GetResponse;
import com.yandex.direct.api.v5.feeds.UpdateRequest;
import com.yandex.direct.api.v5.general.ActionResult;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.FeedInfo;
import ru.yandex.direct.core.testing.steps.Steps;

import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.Action.DELETE;
import static ru.yandex.autotests.directapi.model.api5.Action.GET;
import static ru.yandex.autotests.directapi.model.api5.Action.UPDATE;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.FEEDS;

public class FeedSteps extends BaseApiSteps {
    private final Steps steps;

    public FeedSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
        steps = state.getApplicationContext().getBean(Steps.class);
    }

    public GetResponse feedsGet(GetRequest request) {
        return defaultClientV5().invokeMethod(FEEDS, state.getClientLogin(), GET, request);
    }

    public Object shouldGetResultOnAdd(AddRequest request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(FEEDS, state.getClientLogin(), ADD, request);
        List<ActionResult> actualResult = extractActionResults(response, ADD);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnUpdate(UpdateRequest request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(FEEDS, state.getClientLogin(), UPDATE, request);
        List<ActionResult> actualResult = extractActionResults(response, UPDATE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public Object shouldGetResultOnDelete(DeleteRequest request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(FEEDS, state.getClientLogin(), DELETE, request);
        List<ActionResult> actualResult = extractActionResults(response, DELETE);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    public FeedInfo addDefaultFeed(ClientInfo clientInfo) {
        return steps.feedSteps().createDefaultFeed(clientInfo);
    }

    public FeedInfo createFeed(FeedInfo feedInfo) {
        return steps.feedSteps().createFeed(feedInfo);
    }
}
