package ru.yandex.autotests.directapi.steps;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateResponse;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;

import static ru.yandex.autotests.directapi.model.api5.Action.DEDUPLICATE;
import static ru.yandex.autotests.directapi.model.api5.Action.HAS_SEARCH_VOLUME;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.KEYWORDS_RESEARCH;

public class KeywordsResearchSteps extends BaseApiSteps {
    public KeywordsResearchSteps(ApiStepsState state, ConnectionConfig config) {
        super(config, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    public HasSearchVolumeResponse keywordsResearchHasSearchVolumeRawResponse(HasSearchVolumeRequestMap request) {
        return keywordsResearchHasSearchVolumeRawResponse(request, state.getClientLogin());
    }

    public HasSearchVolumeResponse keywordsResearchHasSearchVolumeRawResponse(HasSearchVolumeRequestMap request,
                                                                              String login) {
        return defaultClientV5().invokeMethod(KEYWORDS_RESEARCH, login, HAS_SEARCH_VOLUME, request.getBean());
    }

    public DeduplicateResponse keywordsResearchDeduplicateRawResponse(DeduplicateRequestMap request) {
        return keywordsResearchDeduplicateRawResponse(request, state.getClientLogin());
    }

    public DeduplicateResponse keywordsResearchDeduplicateRawResponse(DeduplicateRequestMap request, String login) {
        return defaultClientV5().invokeMethod(KEYWORDS_RESEARCH, login, DEDUPLICATE, request.getBean());
    }

    public <T extends BeanMap> void shouldGetErrorOnDeduplicate(DeduplicateRequestMap request,
                                                                ExpectedResult... expectedResults) {
        DeduplicateResponse response = keywordsResearchDeduplicateRawResponse(request);
        checkActionResults(response.getFailure(), expectedResults);
    }
}
