package ru.yandex.autotests.directapi.steps;

import java.util.ArrayList;
import java.util.List;

import com.yandex.direct.api.v5.general.ActionResult;
import one.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.KEYWORDS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class KeywordsSteps extends BaseApiSteps {
    public KeywordsSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    public long addDefaultKeyword(Long adGroupId) {
        return addDefaultKeywords(adGroupId, 1).get(0);
    }

    private List<Long> addDefaultKeywords(Long adGroupId, int amount) {
        KeywordAddMap[] keywordAddMaps = new KeywordAddMap[amount];
        for (int i = 0; i < amount; i++) {
            keywordAddMaps[i] = new KeywordAddMap()
                    .defaultKeyword()
                    .withAdGroupId(adGroupId);
        }
        List<Long> keywordIDs = keywordsAdd(keywordAddMaps);
        assumeThat(String.format("добавлено %d ключевых слов", amount), keywordIDs, hasSize(amount));
        return keywordIDs;
    }

    public List<Long> keywordsAdd(KeywordAddMap... keywords) {
        AddRequestMap request = new AddRequestMap().withKeywords(keywords);
        Object response = defaultClientV5().invokeMethod(KEYWORDS, state.getClientLogin(), ADD, request.getBean());
        ArrayList<ActionResult> results = extractActionResults(response, ADD);
        List<ActionResult> errors = StreamEx.of(results).remove(result -> result.getErrors().isEmpty()).toList();
        assertThat("Есть ошибки при вызове метода", errors, is(empty()));
        return StreamEx.of(results).map(ActionResult::getId).toList();
    }

    public Object shouldGetResultOnAdd(AddRequestMap request, ExpectedResult... expectedResults) {
        Object response = defaultClientV5().invokeMethod(KEYWORDS, state.getClientLogin(), ADD, request.getBean());
        ArrayList<ActionResult> actualResult = extractActionResults(response, ADD);
        checkActionResults(actualResult, expectedResults);
        return response;
    }
}
