package ru.yandex.autotests.directapi.steps;

import java.util.List;

import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;
import com.yandex.direct.api.v5.smartadtargets.AddRequest;
import com.yandex.direct.api.v5.smartadtargets.AddResponse;
import com.yandex.direct.api.v5.smartadtargets.DeleteRequest;
import com.yandex.direct.api.v5.smartadtargets.DeleteResponse;
import com.yandex.direct.api.v5.smartadtargets.GetRequest;
import com.yandex.direct.api.v5.smartadtargets.GetResponse;
import com.yandex.direct.api.v5.smartadtargets.ResumeRequest;
import com.yandex.direct.api.v5.smartadtargets.ResumeResponse;
import com.yandex.direct.api.v5.smartadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.smartadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetFieldEnum;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetGetItem;
import com.yandex.direct.api.v5.smartadtargets.SuspendRequest;
import com.yandex.direct.api.v5.smartadtargets.SuspendResponse;
import com.yandex.direct.api.v5.smartadtargets.UpdateRequest;
import com.yandex.direct.api.v5.smartadtargets.UpdateResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceAdGroupInfo;
import ru.yandex.direct.core.testing.info.PerformanceFilterInfo;
import ru.yandex.direct.core.testing.steps.Steps;
import ru.yandex.direct.dbutil.QueryWithForbiddenShardMapping;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

import static java.util.Collections.singleton;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.SMART_AD_TARGETS;
import static ru.yandex.direct.api.v5.entity.smartadtargets.converter.CommonConverters.FACTORY;

public class PerformanceFilterSteps extends BaseApiSteps {
    private final ShardHelper shardHelper;
    private final Steps steps;

    PerformanceFilterSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
        shardHelper = state.getApplicationContext().getBean(ShardHelper.class);
        steps = state.getApplicationContext().getBean(Steps.class);
    }

    @QueryWithForbiddenShardMapping("pid")
    public void addDefaultBidsPerformance(Long adGroupId) {
        int shard = shardHelper.getShardByGroupId(adGroupId);
        steps.performanceFilterSteps().addDefaultBidsPerformance(shard, adGroupId);
    }

    public PerformanceFilterInfo createDefaultPerformanceFilter() {
        return steps.performanceFilterSteps().createDefaultPerformanceFilter();
    }

    public PerformanceFilterInfo addDefaultPerformanceFilter(ClientInfo clientInfo) {
        PerformanceAdGroupInfo adGroupInfo = steps.adGroupSteps().createDefaultPerformanceAdGroup(clientInfo);
        return steps.performanceFilterSteps()
                .addPerformanceFilter(new PerformanceFilterInfo()
                        .withAdGroupInfo(adGroupInfo));
    }

    public GetResponse sendGetRequest(GetRequest getRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.GET, getRequest);
    }

    public SmartAdTargetGetItem getSmartAdTargetGetItem(Long perfFilterId) {
        GetRequest getRequest = FACTORY.createGetRequest()
                .withSelectionCriteria(
                        new AdTargetsSelectionCriteria()
                                .withIds(singleton(perfFilterId)))
                .withFieldNames(SmartAdTargetFieldEnum.values());
        GetResponse getResponse = sendGetRequest(getRequest);
        return getResponse.getSmartAdTargets().get(0);
    }

    public AddResponse sendAddRequest(AddRequest addRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.ADD, addRequest);
    }

    public UpdateResponse sendUpdateRequest(UpdateRequest updateRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.UPDATE, updateRequest);
    }

    public DeleteResponse sendDeleteRequest(DeleteRequest deleteRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.DELETE, deleteRequest);
    }

    public SuspendResponse sendSuspendRequest(SuspendRequest suspendRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.SUSPEND, suspendRequest);
    }

    public ResumeResponse sendResumeRequest(ResumeRequest resumeRequest) {
        return defaultClientV5().invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.RESUME, resumeRequest);
    }

    public SetBidsResponse sendSetBidsRequest(SetBidsRequest setBidsRequest) {
        return defaultClientV5()
                .invokeMethod(SMART_AD_TARGETS, state.getClientLogin(), Action.SET_BIDS, setBidsRequest);
    }

    public AddResponse shouldGetResultOnAddRequest(AddRequest addRequest, ExpectedResult... expectedResults) {
        AddResponse addResponse = sendAddRequest(addRequest);
        List<ActionResult> actualResult = extractActionResults(addResponse, Action.ADD);
        checkActionResults(actualResult, expectedResults);
        return addResponse;
    }

    public void shouldGetResultOnUpdateRequest(UpdateRequest updateRequest, ExpectedResult... expectedResults) {
        UpdateResponse updateResponse = sendUpdateRequest(updateRequest);
        List<ActionResult> actualResult = extractActionResults(updateResponse, Action.UPDATE);
        checkActionResults(actualResult, expectedResults);
    }

    public void shouldGetResultOnSetBidsRequest(SetBidsRequest setBidsRequest, ExpectedResult... expectedResults) {
        SetBidsResponse setBidsResponse = sendSetBidsRequest(setBidsRequest);
        List<ActionResult> actualResult = extractActionResults(setBidsResponse, Action.SET_BIDS);
        checkActionResults(actualResult, expectedResults);
    }

    public void shouldGetResultOnSuspendRequest(SuspendRequest suspendRequest, ExpectedResult... expectedResults) {
        SuspendResponse suspendResponse = sendSuspendRequest(suspendRequest);
        List<ActionResult> actualResult = extractActionResults(suspendResponse, Action.SUSPEND);
        checkActionResults(actualResult, expectedResults);
    }

    public void shouldGetResultOnResumeRequest(ResumeRequest resumeRequest, ExpectedResult... expectedResults) {
        ResumeResponse resumeResponse = sendResumeRequest(resumeRequest);
        List<ActionResult> actualResult = extractActionResults(resumeResponse, Action.RESUME);
        checkActionResults(actualResult, expectedResults);
    }

    public void shouldGetResultOnDeleteRequest(DeleteRequest deleteRequest, ExpectedResult... expectedResults) {
        DeleteResponse deleteResponse = sendDeleteRequest(deleteRequest);
        List<ActionResult> actualResult = extractActionResults(deleteResponse, Action.DELETE);
        checkActionResults(actualResult, expectedResults);
    }

}
