package ru.yandex.autotests.directapi.steps;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyName;

public class PpcPropertiesSteps {
    private final PpcPropertiesSupport ppcPropertiesSupport;

    public PpcPropertiesSteps(ApiStepsState state) {
        ppcPropertiesSupport = state.getApplicationContext().getBean(PpcPropertiesSupport.class);
    }

    public <T> T get(PpcPropertyName<T> name) {
        return ppcPropertiesSupport.get(name).get();
    }

    public String get(String name) {
        return ppcPropertiesSupport.get(name);
    }

    public void set(PpcPropertyName<?> name, String value) {
        ppcPropertiesSupport.set(name, value);
    }

    public void set(PpcPropertyName<Boolean> name, boolean value) {
        ppcPropertiesSupport.set(name, Boolean.toString(value));
    }
}
