package ru.yandex.autotests.directapi.steps;

import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.ClientFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.GroupsFakeSteps;

public class UserSteps {
    private final ApiStepsState state;
    private final ConnectionConfig connectionConfig;

    public UserSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        this.state = state;
        this.connectionConfig = connectionConfig;
    }

    public CampaignSteps campaignSteps() {
        return new CampaignSteps(state, connectionConfig);
    }

    public AdGroupsSteps adGroupsSteps() {
        return new AdGroupsSteps(state, connectionConfig);
    }

    public GroupsFakeSteps groupFakeSteps() {
        return new GroupsFakeSteps(state);
    }

    public ClientFakeSteps clientFakeSteps() {
        return new ClientFakeSteps(state);
    }

    public AdsSteps adsSteps() {
        return new AdsSteps(state, connectionConfig);
    }

    public VcardSteps vCardsSteps() {
        return new VcardSteps(state, connectionConfig);
    }

    public KeywordsSteps keywordsSteps() {
        return new KeywordsSteps(state, connectionConfig);
    }

    public BannersFakeSteps bannersFakeSteps() {
        return new BannersFakeSteps(state);
    }

    public DynamicTextAdTargetsSteps dynamicTextAdTargetsSteps() {
        return new DynamicTextAdTargetsSteps(state, connectionConfig);
    }

    public ImageSteps imagesStepsV5() {
        return new ImageSteps(state);
    }

    public PpcPropertiesSteps ppcPropertiesSteps() {
        return new PpcPropertiesSteps(state);
    }

    public FeatureSteps featureSteps() {
        return new FeatureSteps(state);
    }

    public FeedSteps feedSteps() {
        return new FeedSteps(state, connectionConfig);
    }

    public CreativeSteps creativeSteps() {
        return new CreativeSteps(state, connectionConfig);
    }

    public PerformanceFilterSteps performanceFilterSteps() {
        return new PerformanceFilterSteps(state, connectionConfig);
    }

    public BannerCreativeSteps bannerCreativeSteps() {
        return new BannerCreativeSteps(state, connectionConfig);
    }

    public BidModifiersSteps bidModifiersSteps() {
        return new BidModifiersSteps(state, connectionConfig);
    }

    public KeywordsResearchSteps keywordsResearchSteps() {
        return new KeywordsResearchSteps(state, connectionConfig);
    }

    public DirectJooqDbSteps getDirectJooqDbSteps() {
        return new DirectJooqDbSteps(state);
    }
}
