package ru.yandex.autotests.directapi.steps;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.vcards.AddResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;

import static java.util.stream.Collectors.toList;
import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.VCARDS;

public class VcardSteps extends BaseApiSteps {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public VcardSteps(ApiStepsState state, ConnectionConfig connectionConfig) {
        super(connectionConfig, new RequestHeader(state.getClientLogin(), state.getToken()), state);
    }

    public Long addDefaultVCard(Long campaignId) {
        return this.vCardsAdd(new VCardAddMap().defaultContacts().withCampaignId(campaignId)).get(0);
    }

    public AddResponse vCardsAdd(AddRequestMap request) {
        return defaultClientV5().invokeMethod(VCARDS, state.getClientLogin(), ADD, request.getBean());
    }

    public List<Long> vCardsAdd(VCardAddMap... vcards) {
        AddRequestMap request = new AddRequestMap().withVCards(vcards);
        return this.vCardsAdd(request).getAddResults().stream().map(ActionResult::getId).collect(toList());
    }
}
