package ru.yandex.direct.domain.ad

import ru.yandex.direct.domain.adgroup.AdGroup
import ru.yandex.direct.domain.adgroup.AdGroupID

/**
 * Defines identifier type for [Ad].
 */
@JvmInline
value class AdID(val value: Long)

/**
 * Объявление представляет собой рекламный материал. Набор параметров объявления зависит от его типа.
 *
 * @see TextBanner
 */
sealed class Ad(
    val id: AdID,
)

class BaseAd(id: AdID): Ad(id)

class DynamicAd(id: AdID): Ad(id)

class MobileContentAd(id: AdID): Ad(id)

class PerformanceAd(id: AdID): Ad(id)

class McAd(id: AdID): Ad(id)

class CpmAd(id: AdID): Ad(id)

class CpmVideoAd(id: AdID): Ad(id)

class CpmOutdoorAd(id: AdID): Ad(id)

class CpmYandexFrontpageAd(id: AdID): Ad(id)

class CpmIndoorAd(id: AdID): Ad(id)

class InternalAd(id: AdID): Ad(id)

class ContentPromotionVideoAd(id: AdID): Ad(id)

class CpmGeoProductAd(id: AdID): Ad(id)

class CpmAudioAd(id: AdID): Ad(id)

class ContentPromotionAd(id: AdID): Ad(id)

class CpmPriceAd(id: AdID): Ad(id)

class CpmGeoPinAd(id: AdID): Ad(id)
