package ru.yandex.direct.domain.adgroup

import ru.yandex.direct.domain.ad.BaseAd
import ru.yandex.direct.domain.ad.ContentPromotionAd
import ru.yandex.direct.domain.ad.ContentPromotionVideoAd
import ru.yandex.direct.domain.ad.CpmAd
import ru.yandex.direct.domain.ad.CpmAudioAd
import ru.yandex.direct.domain.ad.CpmGeoPinAd
import ru.yandex.direct.domain.ad.CpmGeoProductAd
import ru.yandex.direct.domain.ad.CpmIndoorAd
import ru.yandex.direct.domain.ad.CpmOutdoorAd
import ru.yandex.direct.domain.ad.CpmPriceAd
import ru.yandex.direct.domain.ad.CpmVideoAd
import ru.yandex.direct.domain.ad.CpmYandexFrontpageAd
import ru.yandex.direct.domain.ad.DynamicAd
import ru.yandex.direct.domain.ad.InternalAd
import ru.yandex.direct.domain.ad.McAd
import ru.yandex.direct.domain.ad.MobileContentAd
import ru.yandex.direct.domain.ad.PerformanceAd

/**
 * Defines identifier type for [AdGroup].
 */
@JvmInline
value class AdGroupID(val value: Long) : Comparable<AdGroupID> {
    override fun compareTo(other: AdGroupID) = value.compareTo(other.value)
}

/**
 * Группа объявлений представляет собой набор объявлений и единые для этих объявлений условия показа.
 * С помощью групп можно протестировать различные варианты объявления и автоматически определить,
 * какой из них окажется наиболее привлекательным для аудитории.
 */
sealed class AdGroup(
    val id: AdGroupID,
)

class BaseAdGroup(id: AdGroupID, val ads: Collection<BaseAd>) : AdGroup(id)

class DynamicAdGroup(id: AdGroupID, val ads: Collection<DynamicAd>) : AdGroup(id)

class MobileContentAdGroup(id: AdGroupID, val ads: Collection<MobileContentAd>) : AdGroup(id)

class PerformanceAdGroup(id: AdGroupID, val ads: Collection<PerformanceAd>) : AdGroup(id)

class McAdGroup(id: AdGroupID, val ads: Collection<McAd>) : AdGroup(id)

class InternalGroup(id: AdGroupID, val ads: Collection<InternalAd>) : AdGroup(id)

class ContentPromotionVideoAdGroup(id: AdGroupID, val ads: Collection<ContentPromotionVideoAd>) : AdGroup(id)

class ContentPromotionGroup(id: AdGroupID, val ads: Collection<ContentPromotionAd>) : AdGroup(id)

sealed class CpmAdGroup(id: AdGroupID) : AdGroup(id)

class CpmBannerAdGroup(id: AdGroupID, val ads: Collection<CpmAd>) : CpmAdGroup(id)

class CpmVideoAdGroup(id: AdGroupID, val ads: Collection<CpmVideoAd>) : CpmAdGroup(id)

class CpmOutdoorGroup(id: AdGroupID, val ads: Collection<CpmOutdoorAd>) : CpmAdGroup(id)

class CpmYandexFrontpageGroup(id: AdGroupID, val ads: Collection<CpmYandexFrontpageAd>) : CpmAdGroup(id)

class CpmIndoorAdGroup(id: AdGroupID, val ads: Collection<CpmIndoorAd>) : CpmAdGroup(id)

class CpmGeoProductGroup(id: AdGroupID, val ads: Collection<CpmGeoProductAd>) : CpmAdGroup(id)

class CpmAudioGroup(id: AdGroupID, val ads: Collection<CpmAudioAd>) : CpmAdGroup(id)

class CpmPriceGroup(id: AdGroupID, val ads: Collection<CpmPriceAd>) : CpmAdGroup(id)

class CpmGeoPinGroup(id: AdGroupID, val ads: Collection<CpmGeoPinAd>) : CpmAdGroup(id)
