package ru.yandex.direct.domain.campaign

/**
 * Defines identifier type for [Campain].
 */
@JvmInline
value class CampaignID(val value: Long) : Comparable<CampaignID> {
    override fun compareTo(other: CampaignID) = value.compareTo(other.value)
}

/**
 * Объект Кампания [Campaign] содержит настройки рекламной кампании и суммарную статистику.
 */
sealed class Campaign(
    open val id: CampaignID
)

class TextCampaign(id: CampaignID) : Campaign(id)

class MCBCampaign(id: CampaignID) : Campaign(id)

class GeoCampaign(id: CampaignID) : Campaign(id)

class WalletCampaign(id: CampaignID) : Campaign(id)

class MobileContentCampaign(id: CampaignID) : Campaign(id)

class PerformanceCampaign(id: CampaignID) : Campaign(id)

class DynamicCampaign(id: CampaignID) : Campaign(id)

class McBannerCampaign(id: CampaignID) : Campaign(id)

class BillingAggregateCampaign(id: CampaignID) : Campaign(id)

class InternalDistribCampaign(id: CampaignID) : Campaign(id)

class InternalFreeCampaign(id: CampaignID) : Campaign(id)

class InternalAutobudgetCampaign(id: CampaignID) : Campaign(id)

class ContentPromitionCampaign(id: CampaignID) : Campaign(id)

sealed class CpmCampaign(id: CampaignID) : Campaign(id)

class CpmBannerCampaign(id: CampaignID) : CpmCampaign(id)

class CpmDealsCampaign(id: CampaignID) : CpmCampaign(id)

class CpmYandexFrontpageCampaign(id: CampaignID) : CpmCampaign(id)

class CpmPriceCampaign(id: CampaignID) : CpmCampaign(id)
