package ru.yandex.direct.domain.client

/**
 * Defines identifier type for [Client].
 */
@JvmInline
value class ClientID(val value: Long) : Comparable<ClientID> {
    override fun compareTo(other: ClientID) = value.compareTo(other.value)
}

@JvmInline
value class PassportID(val value: Long) : Comparable<PassportID> {
    override fun compareTo(other: PassportID) = value.compareTo(other.value)
}

@JvmInline
value class PassportLogin(val value: String) : Comparable<PassportLogin> {
    override fun compareTo(other: PassportLogin) = value.compareTo(other.value)
}

/**
 * Объект Клиент (Client) соответствует рекламодателю или рекламному агентству.
 * - Рекламодатели подразделяются на прямых рекламодателей и клиентов агентств.
 * - Рекламодателю принадлежат его рекламные кампании.
 * - Агентству логически подчинены рекламодатели — клиенты этого агентства.
 */
data class Client(
    val id: ClientID,

    val passportId: PassportID,

    val passportLogin: PassportLogin,
)
