package ru.yandex.direct.domain.retargeting

import ru.yandex.direct.domain.client.ClientID

interface RetargetingConditionRepository {
    fun findById(id: RetargetingConditionID): RetargetingCondition?

    fun findForClient(clientId: ClientID): Collection<RetargetingCondition>

    fun findInterestsForClient(clientId: ClientID): Collection<InterestsRetargetingCondition>

    /**
     * Creates retargeting condition and returns RetargetingID of new entity
     */
    fun create(retargetingCondition: RetargetingCondition): RetargetingConditionID?
}
