package ru.yandex.direct.domain.retargeting

import ru.yandex.direct.domain.adgroup.AdGroupID
import ru.yandex.direct.domain.campaign.CampaignID
import java.math.BigDecimal
import java.time.Instant

/**
 * Ретаргетинг.
 */

/**
 * Defines identifier type for [Retargeting].
 */
@JvmInline
value class RetargetingID(val value: Long) : Comparable<RetargetingID> {
    override fun compareTo(other: RetargetingID) = value.compareTo(other.value)
}

data class Retargeting(
    val id: RetargetingID,
    val adGroupID: AdGroupID,
    val campaignID: CampaignID,
    val condition: RetargetingCondition,
    val lastChangeTime: Instant,
    val suspended: Boolean,
    val priceContext: BigDecimal,
)
