package ru.yandex.direct.domain.retargeting

/**
 * Тип объединения целей в правиле.
 */
enum class RuleType {
    /**
     * Правило выполнено, если пользователь не выполнил ни одну из целей и не входит ни в один из сегментов.
     */
    NONE,

    /**
     * Правило выполнено, если пользователь выполнил хотя бы одну из целей или входит хотя бы в один из сегментов.
     */
    ANY,

    /**
     * Правило выполнено, если пользователь выполнил все цели и входит во все сегменты.
     */
    ALL
}

/**
 * Sealed-класс для всех правил.
 */
sealed class Rule(open val type: RuleType)

/**
 * Правило для ретаргетинга по интересам [InterestsRetargetingCondition]. Может содержать только одну цель [InterestsGoal].
 */
data class InterestsRule(override val type: RuleType, val goal: InterestsGoal) : Rule(type)

/**
 * Правило для ретаргетинга по целям метрики [InterestsRetargetingCondition]. Может содержать несколько целе [MetrikaGoal].
 */
data class MetrikaRule(override val type: RuleType, val goals: Collection<MetrikaGoal>) : Rule(type)

/**
 * Пока не известные классы правил для остальных типов.
 */
data class GenericRule(override val type: RuleType, val goals: Collection<Goal>) : Rule(type), Collection<Goal> by goals
