package ru.yandex.direct.domain.retargeting

import ru.yandex.direct.domain.client.PassportID
import ru.yandex.direct.domain.client.RBACService

/**
 * Сервис для работы с ретаргетингами.
 */
class RetargetingService(
    private val retargetingRepository: RetargetingRepository,
    private val rbacService: RBACService
) {
    /**
     * Получение всех ретаргетингов, удовлетворяющих [SelectionCriteria] и доступных для пользователя [operatorId].
     */
    fun get(selection: SelectionCriteria, operatorId: PassportID): Collection<Retargeting> {
        val retargetings = retargetingRepository.findBySelection(selection)

        val readableCampaigns = rbacService.filterReadableCampaigns(operatorId, retargetings.map { it.campaignID })

        return retargetings.filter { it.campaignID in readableCampaigns }
    }
}
