package ru.yandex.direct.infrastructure.mysql.column_types

import kotlinx.serialization.decodeFromString
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import org.jetbrains.exposed.sql.Column
import org.jetbrains.exposed.sql.Table

inline fun <reified T : Any> Table.json(name: String): Column<T> =
    stringWrapper(name, Json::decodeFromString, Json::encodeToString)
