package ru.yandex.direct.infrastructure.mysql.sharding

import org.jetbrains.exposed.dao.Entity
import org.jetbrains.exposed.dao.EntityClass
import org.jetbrains.exposed.dao.id.EntityID
import org.jetbrains.exposed.dao.id.IdTable
import org.jetbrains.exposed.sql.Column
import ru.yandex.direct.domain.retargeting.RetargetingConditionID
import ru.yandex.direct.domain.retargeting.RetargetingID
import ru.yandex.direct.infrastructure.mysql.column_types.retCondId
import ru.yandex.direct.infrastructure.mysql.column_types.retargetingId
import ru.yandex.direct.infrastructure.mysql.sharding.ShardIncRetCondIds.ClientID

/**
 * Таблица, выдающая уникальный идентификатор ретаргетингу.
 */
object IncRetIds : IdTable<RetargetingID>("inc_ret_id") {
    override val id: Column<EntityID<RetargetingID>> = retargetingId("ret_id").entityId()
    override val primaryKey = PrimaryKey(id)
}

/**
 * DAO для таблицы [ShardIncRetCondIds].
 */
class IncRetId(id: EntityID<RetargetingID>) : Entity<RetargetingID>(id) {
    companion object : EntityClass<RetargetingID, IncRetId>(IncRetIds)
}
