package ru.yandex.direct.infrastructure.mysql.sharding

import org.jetbrains.exposed.dao.Entity
import org.jetbrains.exposed.dao.EntityClass
import org.jetbrains.exposed.dao.id.EntityID
import org.jetbrains.exposed.dao.id.IdTable
import org.jetbrains.exposed.sql.Column
import ru.yandex.direct.domain.client.ClientID
import ru.yandex.direct.infrastructure.mysql.column_types.clientId

/**
 * Таблица, связывающая идентификатор клиента [ClientID] с номером шарда.
 */
object ShardClientIds : IdTable<ClientID>("shard_client_id") {
    override val id: Column<EntityID<ClientID>> = clientId("ClientID").entityId()
    val shard: Column<Int> = integer("shard")
    override val primaryKey = PrimaryKey(id)
}

/**
 * DAO для таблицы [ShardClientIds].
 */
class ShardClientId(id: EntityID<ClientID>) : Entity<ClientID>(id) {
    companion object : EntityClass<ClientID, ShardClientId>(ShardClientIds)

    var shard by ShardClientIds.shard
}
