package ru.yandex.direct.infrastructure.mysql.sharding

import org.jetbrains.exposed.dao.Entity
import org.jetbrains.exposed.dao.EntityClass
import org.jetbrains.exposed.dao.id.EntityID
import org.jetbrains.exposed.dao.id.IdTable
import org.jetbrains.exposed.sql.Column
import ru.yandex.direct.domain.retargeting.RetargetingConditionID
import ru.yandex.direct.infrastructure.mysql.column_types.retCondId
import ru.yandex.direct.infrastructure.mysql.sharding.ShardIncRetCondIds.ClientID

/**
 * Таблица, связывающая идентификатор условия ретаргетинга с [ClientID].
 */
object ShardIncRetCondIds : IdTable<RetargetingConditionID>("shard_inc_ret_cond_id") {
    override val id: Column<EntityID<RetargetingConditionID>> = retCondId("ret_cond_id").entityId().autoIncrement()
    val ClientID = reference("ClientID", ShardClientIds)
    override val primaryKey = PrimaryKey(id)
}

/**
 * DAO для таблицы [ShardIncRetCondIds].
 */
class ShardIncRetCondId(id: EntityID<RetargetingConditionID>) : Entity<RetargetingConditionID>(id) {
    companion object : EntityClass<RetargetingConditionID, ShardIncRetCondId>(ShardIncRetCondIds)

    var client by ShardClientId referencedOn ClientID
}
