package ru.yandex.direct.infrastructure.mysql.sharding

import org.jetbrains.exposed.dao.Entity
import org.jetbrains.exposed.dao.EntityClass
import org.jetbrains.exposed.dao.id.EntityID
import org.jetbrains.exposed.dao.id.IdTable
import org.jetbrains.exposed.sql.Column
import ru.yandex.direct.domain.client.PassportLogin
import ru.yandex.direct.infrastructure.mysql.column_types.passportLogin

/**
 * Таблица, связывающая логин из пасспорта с идентификатором пользователя из пасспорта.
 */
object ShardLogins : IdTable<PassportLogin>("shard_login") {
    override val id: Column<EntityID<PassportLogin>> = passportLogin("login").entityId()
    val uid = reference("uid", ShardUids)
    override val primaryKey = PrimaryKey(id)
}

/**
 * DAO для таблицы [ShardLogins].
 */
class ShardLogin(id: EntityID<PassportLogin>) : Entity<PassportLogin>(id) {
    companion object : EntityClass<PassportLogin, ShardLogin>(ShardLogins)

    var uid by ShardUid referencedOn ShardLogins.uid
}
