package ru.yandex.direct.infrastructure.mysql.sharding

import org.jetbrains.exposed.dao.Entity
import org.jetbrains.exposed.dao.EntityClass
import org.jetbrains.exposed.dao.id.EntityID
import org.jetbrains.exposed.dao.id.IdTable
import org.jetbrains.exposed.sql.Column
import ru.yandex.direct.domain.client.PassportID
import ru.yandex.direct.infrastructure.mysql.sharding.ShardUids.ClientID
import ru.yandex.direct.infrastructure.mysql.column_types.passportId

/**
 * Таблица, связывающая идентификатор пользователя в пасспорте с [ClientID].
 */
object ShardUids : IdTable<PassportID>("shard_uid") {
    override val id: Column<EntityID<PassportID>> = passportId("id").entityId()
    val ClientID = reference("ClientID", ShardClientIds)
    override val primaryKey = PrimaryKey(id)
}

/**
 * DAO для таблицы [ShardUids].
 */
class ShardUid(id: EntityID<PassportID>) : Entity<PassportID>(id) {
    companion object : EntityClass<PassportID, ShardUid>(ShardUids)

    var client by ShardClientId referencedOn ShardUids.ClientID
}
