package ru.yandex.direct.infrastructure.mysql.tables

import org.jetbrains.exposed.sql.Table
import org.jetbrains.exposed.sql.javatime.CurrentTimestamp
import org.jetbrains.exposed.sql.javatime.timestamp
import ru.yandex.direct.domain.adgroup.AdGroupID
import ru.yandex.direct.domain.campaign.CampaignID
import ru.yandex.direct.domain.retargeting.RetargetingConditionID
import ru.yandex.direct.infrastructure.mysql.column_types.adGroupId
import ru.yandex.direct.infrastructure.mysql.column_types.campaignId
import ru.yandex.direct.infrastructure.mysql.column_types.retCondId
import ru.yandex.direct.infrastructure.mysql.column_types.retargetingId

enum class BsSynced {
    NO,
    YES,
    SENDING
}

/**
 * Таблица связывающая условия ретаргетинга с баннерами, группами и кампаниями.
 */
object BidsRetargeting : Table("bids_retargeting") {
    var id = retargetingId("ret_id")

    var retCondId = retCondId("ret_cond_id").default(RetargetingConditionID(0))

    var adGroupId = (adGroupId("pid") references Phrases.id).default(AdGroupID(0))

    var campaignId = (campaignId("cid") references Campaigns.id).default(CampaignID(0))

    var isSuspended = bool("is_suspended").default(false)

    var statusBsSynced = customEnumeration("statusBsSynced",
        "ENUM('no','yes','sending')",
        { value -> BsSynced.valueOf((value as String).uppercase()) },
        { it.name.lowercase() }).default(BsSynced.NO)

    var modTime = timestamp("modtime").defaultExpression(CurrentTimestamp())

    var priceContext = decimal("price_context", 10, 2)
}
