package ru.yandex.direct.infrastructure.mysql.tables

import org.jetbrains.exposed.sql.Column
import org.jetbrains.exposed.sql.Table
import ru.yandex.direct.infrastructure.mysql.column_types.campaignId

enum class YesNo {
    YES,
    NO
}

enum class CampaignType {
    TEXT,

    MCB,

    GEO,

    WALLET,

    MOBILE_CONTENT,

    PERFORMANCE,

    DYNAMIC,

    MCBANNER,

    CPM_BANNER,

    CPM_DEALS,

    CPM_YNDX_FRONTPAGE,

    BILLING_AGGREGATE,

    INTERNAL_DISTRIB,

    INTERNAL_FREE,

    INTERNAL_AUTOBUDGET,

    CONTENT_PROMOTION,

    CPM_PRICE
}

/**
 * Основные данные про кампанию (дополнительные - CampaignOptions).
 */
object Campaigns : Table("campaigns") {
    val id = campaignId("cid")
    override val primaryKey = PrimaryKey(id)

    val statusEmpty: Column<YesNo> = customEnumeration("statusEmpty",
        "ENUM('yes','no')",
        { value -> YesNo.valueOf((value as String).uppercase()) },
        { it.name.lowercase() })

    var type = customEnumeration(
        "type",
        "ENUM('text', 'mcb', 'geo', 'wallet', 'mobile_content', 'performance', 'dynamic', 'mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'billing_aggregate', 'internal_distrib', 'internal_free', 'internal_autobudget', 'content_promotion', 'cpm_price')",
        { value -> CampaignType.valueOf((value as String).uppercase()) },
        { it.name.lowercase() })
}
