package ru.yandex.direct.infrastructure.mysql.tables

import kotlinx.serialization.Serializable
import org.jetbrains.exposed.sql.Column
import org.jetbrains.exposed.sql.Table
import org.jetbrains.exposed.sql.javatime.timestamp
import java.time.Instant

@Serializable
enum class GoalType {
    GOAL,
    SEGMENT_GOAL,
    AUDIENCE,
    ECOMMERCE,
    SOCIAL_DEMO,
    FAMILY,
    INTERESTS,
    AB_SEGMENT,
    BEHAVIORS,
    AUDIO_GENRES,
    BRANDSAFETY,
    INTERNAL,
    LAL_SEGMENT,
    CONTENT_CATEGORY,
    CONTENT_GENRE,
    CDP_SEGMENT,
    MOBILE,
    HOST
}

enum class GoalSource {
    METRIKA,
    CRYPTA,
    DIRECT
}

object RetargetingGoals : Table("retargeting_goals") {
    var retCondId: Column<Long> = long("ret_cond_id")

    var goalId: Column<Long> = long("goal_id")

    var isAccessible: Column<Boolean> = bool("is_accessible")

    var modTime: Column<Instant> = timestamp("modtime")

    var goalType: Column<GoalType> = customEnumeration(
        "goal_type",
        "ENUM('goal','segment','audience','ecommerce','social_demo','family','interests','ab_segment','behaviors','audio_genres','brandsafety','internal','lal_segment','content_category','content_genre','cdp_segment','mobile','host')",
        { value -> GoalType.valueOf((value as String).uppercase()) },
        { it.name.lowercase() })

    var goalSource: Column<GoalSource> = customEnumeration(
        "goal_source",
        "ENUM('metrika','crypta','direct')",
        { value -> GoalSource.valueOf((value as String).uppercase()) },
        { it.name.lowercase() })
}
