package ru.yandex.direct.libs.nonEmptyCollection

interface NonEmptyCollection<out T> : Collection<T> {
    @Deprecated(
        level = DeprecationLevel.ERROR,
        message = "Is never null",
        replaceWith = ReplaceWith("first()")
    )
    fun firstOrNull(): T = first()

    @Deprecated(
        level = DeprecationLevel.ERROR,
        message = "Alternative is never used",
        replaceWith = ReplaceWith("")
    )
    fun <R> ifEmpty(defaultValue: () -> R): R = throw NotImplementedError()

    @Deprecated(
        level = DeprecationLevel.ERROR,
        message = "It always false",
        replaceWith = ReplaceWith("")
    )
    override fun isEmpty(): Boolean = false
}

@Deprecated(
    level = DeprecationLevel.ERROR,
    message = "Alternative is never used",
    replaceWith = ReplaceWith("first()")
)
fun <T> NonEmptyCollection<T>.firstOr(@Suppress("UNUSED_PARAMETER") alternative: () -> T): T = first()

