package ru.yandex.direct.libs.nonEmptyCollection.list

import ru.yandex.direct.libs.nonEmptyCollection.NonEmptyCollection

class NonEmptyList<out T> internal constructor(
    internal val full: List<T>
) : List<T> by full, NonEmptyCollection<T> {

    internal constructor(
        head: T,
        tail: List<T>
    ) : this(
        full = ArrayList<T>(tail.size + 1).apply {
            add(head)
            addAll(tail)
        }
    )

    init {
        require(full.isNotEmpty()) {
            "Fatal Error! This is a bug. Please contact the library author."
        }
    }

    override fun toString(): String = full.toString()

    override fun equals(other: Any?): Boolean = full == other

    override fun hashCode(): Int = full.hashCode()

    @Deprecated(
        level = DeprecationLevel.ERROR,
        message = "It always false",
        replaceWith = ReplaceWith("")
    )
    override fun isEmpty() = false
}
