@file:Suppress("unused")

package ru.yandex.direct.libs.nonEmptyCollection.set

import ru.yandex.direct.libs.nonEmptyCollection.NonEmptyCollection
import ru.yandex.direct.libs.nonEmptyCollection.unsafe.toNonEmptySet
import ru.yandex.direct.libs.nonEmptyCollection.unsafe.wrapOperator

fun <T> NonEmptyCollection<T>.toNonEmptySet(): NonEmptySet<T> = toNonEmptySet()

fun <T> NonEmptySet<T>.onEach(
    action: (T) -> Unit
): NonEmptySet<T> = wrapOperator(action, Set<T>::onEach)

fun <T> NonEmptySet<T>.onEachIndexed(
    action: (index: Int, T) -> Unit
): NonEmptySet<T> = wrapOperator(action, Set<T>::onEachIndexed)

fun <T> NonEmptyCollection<T>.union(other: Iterable<T>): NonEmptySet<T> =
    wrapOperator(other, Iterable<T>::union)
