@file:Suppress("unused")

package ru.yandex.direct.libs.nonEmptyCollection

import ru.yandex.direct.libs.nonEmptyCollection.list.NonEmptyList
import ru.yandex.direct.libs.nonEmptyCollection.map.NonEmptyMap
import ru.yandex.direct.libs.nonEmptyCollection.set.NonEmptySet
import ru.yandex.direct.libs.nonEmptyCollection.unsafe.toNonEmptyList
import ru.yandex.direct.libs.nonEmptyCollection.unsafe.toNonEmptyMap
import ru.yandex.direct.libs.nonEmptyCollection.unsafe.toNonEmptySet

fun <T> List<T>.toNonEmptyListOr(
    alternative: List<T>.() -> NonEmptyList<T>
) = if (isEmpty()) alternative() else toNonEmptyList()

fun <T> Set<T>.toNonEmptySetOr(
    alternative: Set<T>.() -> NonEmptySet<T>
) = if (isEmpty()) alternative() else toNonEmptySet()

fun <K, V> Map<K, V>.toNonEmptyMapOr(
    alternative: Map<K, V>.() -> NonEmptyMap<K, V>
) = if (isEmpty()) alternative() else toNonEmptyMap()
