#!/usr/bin/env bash

set -e

if [ "${ENVIRONMENT_TYPE}" = "production" ]; then
    # Production
    JAVA_ENVIRONMENT_OPTIONS="-Xms256m -Xmx2048m"
elif [ "${ENVIRONMENT_TYPE}" = "testing" ]; then
    # Testing
    JAVA_ENVIRONMENT_OPTIONS="-Xms256m -Xmx512m"
else
    echo "Unknown environment type \"${ENVIRONMENT_TYPE}\"" && exit 1
fi

case "$DIRECT_ENVIRONMENT_TYPE" in
    devtest)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.devtest.json
        )
        ;;
    testing)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.test.json
        )
        ;;
    production)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/db-config.json
        )
        ;;
    *)
        echo "Unknown direct environment type \"${DIRECT_ENVIRONMENT_TYPE}\"" && exit 1
        ;;
esac

JAVA_ADDITIONAL_ARGS+=(
    -Dnetwork_config=zk:///direct/network-config.json
)

if [ "${ACTIVE_QUEUES}" = "" ]; then
    echo "Should be specified at least one queue" && exit 1
fi

export SPRING_PROFILES_ACTIVE="${ENVIRONMENT_TYPE},${ACTIVE_QUEUES}"

java -server \
    -showversion \
    -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=38100 \
    ${JAVA_ENVIRONMENT_OPTIONS} \
    ${JAVA_ADDITIONAL_ARGS[@]} \
    -XX:-OmitStackTraceInFastThrow \
    -Dcom.sun.management.jmxremote=true \
    -Dcom.sun.management.jmxremote.port=38101 \
    -Dcom.sun.management.jmxremote.rmi.port=38101 \
    -Dcom.sun.management.jmxremote.authenticate=false \
    -Dcom.sun.management.jmxremote.ssl=false \
    -Djava.rmi.server.hostname=localhost \
    -Djava.net.preferIPv4Stack=false \
    -Djava.net.preferIPv6Addresses=true \
    -Dfile.encoding=UTF-8 \
    -Djava.awt.headless=true \
    -Djava.security.egd=file:/dev/./urandom \
    -Dsun.net.client.defaultConnectTimeout=10000 \
    -Dsun.net.client.defaultReadTimeout=10000 \
    -Dsun.net.inetaddr.ttl=60 \
    -Dhttp.keepAlive=false \
    -Duser.language=en \
    -Duser.country=US \
    -Duser.timezone=GMT \
    -Dyandex.environment.type=${DIRECT_ENVIRONMENT_TYPE} \
    -cp "/usr/lib/yandex/bannerstorage-harvester/*" \
    ru.yandex.bannerstorage.harvester.Application
