package ru.yandex.bannerstorage.harvester;

import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.Import;

import ru.yandex.bannerstorage.harvester.configs.GlobalConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.AutoModerationConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.ProcessDynamicCodeConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.RtbIntegrationConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.ScreenshooterConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.TardisConfig;
import ru.yandex.bannerstorage.harvester.configs.queues.TaskQueueConfig;
import ru.yandex.bannerstorage.messaging.MessagingConfig;

// По сути эти две аннотации -- это замена @SpringBootApplication, но без @ComponentScan
// (т.к. @ComponentScan мешает конфигурации контроллеров)
@SpringBootConfiguration
@EnableAutoConfiguration
@Import({
        GlobalConfig.class,
        MessagingConfig.class,
        ScreenshooterConfig.class,
        ProcessDynamicCodeConfig.class,
        AutoModerationConfig.class,
        RtbIntegrationConfig.class,
        TardisConfig.class,
        TaskQueueConfig.class
})
public class Application {
    public static void main(String[] args) {
        new SpringApplicationBuilder(Application.class)
                .web(WebApplicationType.SERVLET)
                .bannerMode(Banner.Mode.OFF)
                .run(args);
    }
}
