package ru.yandex.bannerstorage.harvester.configs.queues;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.bannerstorage.harvester.integration.stillage.StillageClient;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.ProcessDynamicCodeQueueObserver;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.FileStorageService;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.impl.AvatarnicaImageStorageService;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.impl.FileStorageServiceImpl;

/**
 * Spring config для JS-обвязок
 *
 * @author egorovmv
 */
@Configuration
@Profile("process_dynamic_codes")
@Lazy(false)
public class ProcessDynamicCodeConfig {
    @Bean
    public FileStorageService fileStorageService(@NotNull JdbcTemplate jdbcTemplate, @NotNull StillageClient stillageClient) {
        return new FileStorageServiceImpl(jdbcTemplate, stillageClient);
    }

    @Bean
    public ImageStorageService imageStorageService(
            @NotNull @Value("${avatarnica.readUrl}") String readUrl,
            @NotNull @Value("${avatarnica.writeUrl}") String writeUrl,
            @NotNull @Value("${avatarnica.namespace}") String namespace) {
        return new AvatarnicaImageStorageService(readUrl, writeUrl, namespace);
    }

    @Bean
    public ProcessDynamicCodeQueueObserver processDynamicCodeQueueObserver(
            @NotNull FileStorageService fileStorageService,
            @NotNull ImageStorageService imageStorageService) {
        return new ProcessDynamicCodeQueueObserver(fileStorageService, imageStorageService);
    }
}
