package ru.yandex.bannerstorage.harvester.configs.queues;

import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.bannerstorage.harvester.integration.direct.DirectClient;
import ru.yandex.bannerstorage.harvester.queues.screenshooter.ScreenShooterQueueObserver;
import ru.yandex.bannerstorage.harvester.queues.screenshooter.ScreenShooterSubscriber;
import ru.yandex.direct.screenshooter.client.configuration.ScreenShooterConfiguration;
import ru.yandex.direct.screenshooter.client.service.ScreenShooterClient;

/**
 * Spring конфиг для screenshoter-а
 *
 * @author egorovmv
 */
@Configuration
@Import({ScreenShooterConfiguration.class})
@Profile("screenshots")
@Lazy(false)
public class ScreenshooterConfig {
    @Bean
    public ScreenShooterSubscriber screenShooterSubscriber(
            @NotNull JdbcTemplate jdbcTemplate, @NotNull ScreenShooterClient screenShooterClient,
            @NotNull DirectClient directClient) {
        return new ScreenShooterSubscriber(jdbcTemplate, screenShooterClient, directClient);
    }

    @Bean
    public ScreenShooterQueueObserver screenShooterQueueObserver(
            @NotNull ScreenShooterSubscriber screenShooterSubscriber) {
        return new ScreenShooterQueueObserver(screenShooterSubscriber);
    }
}
