package ru.yandex.bannerstorage.harvester.configs.queues;

import javax.sql.DataSource;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;

import ru.yandex.bannerstorage.harvester.tardis.infrastracture.JdbcTardisService;
import ru.yandex.bannerstorage.harvester.tardis.infrastracture.TardisService;
import ru.yandex.bannerstorage.harvester.tardis.infrastracture.VhClient;
import ru.yandex.bannerstorage.harvester.tardis.infrastracture.impl.HttpVhClientIml;
import ru.yandex.bannerstorage.harvester.tardis.infrastracture.impl.JdbcTardisServiceImpl;
import ru.yandex.bannerstorage.harvester.tardis.infrastracture.impl.TardisServiceImpl;
import ru.yandex.bannerstorage.harvester.utils.RestTemplateFactory;

/**
 * Spring config для файлконвертера
 *
 * @author freakbelka
 */
@Configuration
@Profile("tardis")
@Lazy(false)
public class TardisConfig {

    @Bean
    public VhClient vhClient(
            @NotNull RestTemplateFactory restTemplateFactory,

            @Value("${cms.url}") String serviceUrl,
            @Value("${rtbHost.connectTimeoutInMS:60000}") int connectTimeoutInMS,
            @Value("${rtbHost.readTimeoutInMS:60000}") int readTimeoutInMS)
    {
        return new HttpVhClientIml(restTemplateFactory, serviceUrl, connectTimeoutInMS, readTimeoutInMS);

    }

    @Bean
    public JdbcTardisService jdbcTardisService(@NotNull DataSource dataSource) {
        return new JdbcTardisServiceImpl(dataSource);
    }

    @Bean
    public TardisService tardisService(
            @NotNull JdbcTardisService jdbcTardisService,
            @NotNull VhClient vhClient,
            @Value("${vod.provider.id}") String vhId)
    {
        return new TardisServiceImpl(jdbcTardisService, vhClient, vhId);
    }
}
