package ru.yandex.bannerstorage.harvester.configs.queues;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.bannerstorage.harvester.queues.CreativeSendToRTBHostTaskProcessor;
import ru.yandex.bannerstorage.harvester.queues.TaskQueueObserver;
import ru.yandex.bannerstorage.harvester.queues.TaskRepository;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.services.CreativeService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbClientService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbIntegrationHealthService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.impl.BsApiClientService;
import ru.yandex.direct.bs.dspcreative.configuration.BsDspCreativeConfiguration;
import ru.yandex.direct.bs.dspcreative.service.DspCreativeYtExporter;

@Configuration
@Import({BsDspCreativeConfiguration.class})
@Profile("rtb_creative_changed")
@Lazy(false)
public class TaskQueueConfig {
    @Bean
    CreativeSendToRTBHostTaskProcessor creativeSendToRTBHostTaskProcessor(
            CreativeService creativeService,
            RtbClientService rtbClientService,
            DspCreativeYtExporter dspCreativeYtExporter,
            RtbIntegrationHealthService healthService,
            BsApiClientService bsApiClientService) {
        return new CreativeSendToRTBHostTaskProcessor(
                creativeService, rtbClientService, dspCreativeYtExporter, healthService, bsApiClientService, 10);
    }

    @Bean
    TaskRepository taskRepository(JdbcTemplate jdbcTemplate) {
        return new TaskRepository(jdbcTemplate);
    }

    @Bean(initMethod = "start", destroyMethod = "stop")
    TaskQueueObserver creativeSendToRTBHostTaskObserver(TaskRepository taskRepository,
                                                        CreativeSendToRTBHostTaskProcessor taskProcessor) {
        return new TaskQueueObserver("t_task_queue", "send_to_rtb", taskProcessor, taskRepository, 200);
    }
}
