package ru.yandex.bannerstorage.harvester.controllers;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.bannerstorage.harvester.infrastructure.MonitoringProvider;

/**
 * @author egorovmv
 */
@RestController
public class MonitoringController {
    private final MonitoringProvider monitoringProvider;

    public MonitoringController(@NotNull MonitoringProvider monitoringProvider) {
        this.monitoringProvider = Objects.requireNonNull(monitoringProvider, "monitoringProvider");
    }

    @RequestMapping(value = "ping", method = RequestMethod.GET, produces = MediaType.TEXT_PLAIN_VALUE)
    public ResponseEntity<String> ping() {
        return monitoringProvider.test()
                ? ResponseEntity.ok("0;OK")
                : ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).body("1;FAIL");
    }
}
