package ru.yandex.bannerstorage.harvester.controllers;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbClientService;

/**
 * @author elwood
 */
@RestController
@Profile({"rtb_creative_changed", "rtb_postmoderation"})
public class SettingsController {
    private final RtbClientService rtbClientService;

    public SettingsController(RtbClientService rtbClientService) {
        this.rtbClientService = rtbClientService;
    }

    public static class Settings {
        @JsonProperty("rtbhostUrl")
        private String rtbhostUrl;

        public String getRtbhostUrl() {
            return rtbhostUrl;
        }

        public void setRtbhostUrl(String rtbhostUrl) {
            this.rtbhostUrl = rtbhostUrl;
        }
    }

    @RequestMapping(value = "settings", method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Settings> setRtbHostUrl(@RequestBody Settings settings) {
        rtbClientService.setServiceUrl(settings.getRtbhostUrl());
        return ResponseEntity.ok(settings);
    }
}
